'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var redditVideoSettingsMenuDocument = document.currentScript.ownerDocument;

var RedditVideoSettingsMenu = function (_HTMLElement) {
  _inherits(RedditVideoSettingsMenu, _HTMLElement);

  function RedditVideoSettingsMenu() {
    _classCallCheck(this, RedditVideoSettingsMenu);

    var _this = _possibleConstructorReturn(this, (RedditVideoSettingsMenu.__proto__ || Object.getPrototypeOf(RedditVideoSettingsMenu)).call(this));

    var shadowRoot = _this.attachShadow({ mode: "open" });
    var template = redditVideoSettingsMenuDocument.querySelector('#reddit-video-settings-menu');
    var clone = document.importNode(template.content, true);
    shadowRoot.appendChild(clone);
    return _this;
  }

  _createClass(RedditVideoSettingsMenu, [{
    key: 'connectedCallback',
    value: function connectedCallback() {
      var self = this;

      this.container = this.shadowRoot.querySelector('.menu-container');
      this.qualityRadioButtons = this.container.querySelectorAll('input[type=radio]');

      // Unfortunate hack since input name groups are not supported by pollyfilled shadow DOM
      RedditVideoSettingsMenu.count++;
      this.qualityRadioButtons.forEach(function (radioButton) {
        radioButton.setAttribute("name", "quality-" + RedditVideoSettingsMenu.count);
      });

      this.qualityRadioButtons.forEach(function (radioButton) {
        radioButton.addEventListener('change', function (event) {
          var detail = {
            "resolution": radioButton.value
          };
          var resolutionEvent = new CustomEvent('resolution', { 'detail': detail });
          self.dispatchEvent(resolutionEvent);
        });
      }.bind(this));

      // Prevent container click behaviour being triggered
      this.addEventListener('click', function (event) {
        event.stopPropagation();
      });
    }
  }, {
    key: 'updateQualityOptions',
    value: function updateQualityOptions(qualityOptions) {
      this.qualityRadioButtons.forEach(function (qualityRadioButton) {
        if (qualityRadioButton.value === "0") {
          qualityRadioButton.disabled = false;
          qualityRadioButton.checked = true;
        } else {
          qualityRadioButton.disabled = true;
        }
      });
      // For each quality option height, infer the quality by getting the closest height
      qualityOptions.forEach(function (option) {
        var actual = option.height;
        var closest = RedditVideoSettingsMenu.Resolutions.reduce(function (accumulator, currentValue) {
          return Math.abs(currentValue - actual) < Math.abs(accumulator - actual) ? currentValue : accumulator;
        });

        var element = this.shadowRoot.querySelector('input[name="quality"][value="' + closest + '"]');
        if (element) {
          element.disabled = false;
        }
      }.bind(this));
    }
  }, {
    key: 'quality',
    set: function set(value) {
      this._quality = value;
    },
    get: function get() {
      return this._quality;
    }
  }], [{
    key: 'Resolutions',
    get: function get() {
      return [240, 360, 480, 720, 1080];
    }
  }]);

  return RedditVideoSettingsMenu;
}(HTMLElement);

RedditVideoSettingsMenu.count = 0;

customElements.define('reddit-video-settings-menu', RedditVideoSettingsMenu);
